/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataTableDef {
    private TableName table_name;
    private String table_type_class;
    private ArrayList column_list;
    private boolean immutable;
    private transient HashMap col_name_lookup;
    private transient Object COL_LOOKUP_LOCK = new Object();

    public DataTableDef() {
        this.column_list = new ArrayList();
        this.table_type_class = "";
        this.immutable = false;
    }

    public DataTableDef(DataTableDef table_def) {
        this.table_name = table_def.getTableName();
        this.table_type_class = table_def.table_type_class;
        this.column_list = (ArrayList)table_def.column_list.clone();
        this.immutable = false;
    }

    public void setImmutable() {
        this.immutable = true;
    }

    public boolean immutable() {
        return this.immutable;
    }

    private void checkMutable() {
        if (this.immutable()) {
            throw new Error("Tried to mutate immutable object.");
        }
    }

    public void dump(PrintStream out) {
        for (int i = 0; i < this.columnCount(); ++i) {
            this.columnAt(i).dump(out);
            out.println();
        }
    }

    void resolveColumns(boolean ignore_case, Expression exp) {
        if (exp != null) {
            List list = exp.allVariables();
            for (int i = 0; i < list.size(); ++i) {
                Variable v = (Variable)list.get(i);
                String col_name = v.getName();
                if (!ignore_case) continue;
                int size = this.columnCount();
                for (int n = 0; n < size; ++n) {
                    if (!this.columnAt(n).getName().equalsIgnoreCase(col_name)) continue;
                    v.setColumnName(this.columnAt(n).getName());
                }
            }
        }
    }

    public String resolveColumnName(String col_name, boolean ignore_case) throws DatabaseException {
        int size = this.columnCount();
        int found = -1;
        for (int n = 0; n < size; ++n) {
            String this_col_name = this.columnAt(n).getName();
            if (ignore_case && this_col_name.equalsIgnoreCase(col_name)) {
                if (found == -1) {
                    found = n;
                    continue;
                }
                throw new DatabaseException("Ambiguous reference to column '" + col_name + "'");
            }
            if (ignore_case || !this_col_name.equals(col_name)) continue;
            found = n;
        }
        if (found != -1) {
            return this.columnAt(found).getName();
        }
        throw new DatabaseException("Column '" + col_name + "' not found");
    }

    public void resolveColumnsInArray(DatabaseConnection connection, ArrayList list) throws DatabaseException {
        boolean ignore_case = connection.isInCaseInsensitiveMode();
        for (int i = 0; i < list.size(); ++i) {
            String col_name = (String)list.get(i);
            list.set(i, this.resolveColumnName((String)list.get(i), ignore_case));
        }
    }

    public void setTableName(TableName name) {
        this.table_name = name;
    }

    public void setTableClass(String clazz) {
        this.checkMutable();
        if (!clazz.equals("com.mckoi.database.VariableSizeDataTableFile")) {
            throw new Error("Unrecognised table class: " + clazz);
        }
        this.table_type_class = clazz;
    }

    public void addColumn(DataTableColumnDef col_def) {
        this.checkMutable();
        for (int i = 0; i < this.column_list.size(); ++i) {
            DataTableColumnDef cd = (DataTableColumnDef)this.column_list.get(i);
            if (!cd.getName().equals(col_def.getName())) continue;
            throw new Error("Duplicated columns found.");
        }
        this.column_list.add(col_def);
    }

    public void addVirtualColumn(DataTableColumnDef col_def) {
        this.checkMutable();
        this.column_list.add(col_def);
    }

    public String getSchema() {
        String schema_name = this.table_name.getSchema();
        return schema_name == null ? "" : schema_name;
    }

    public String getName() {
        return this.table_name.getName();
    }

    public TableName getTableName() {
        return this.table_name;
    }

    public String getTableClass() {
        return this.table_type_class;
    }

    public int columnCount() {
        return this.column_list.size();
    }

    public DataTableColumnDef columnAt(int column) {
        return (DataTableColumnDef)this.column_list.get(column);
    }

    public int findColumnName(String column_name) {
        int size = this.columnCount();
        for (int i = 0; i < size; ++i) {
            if (!this.columnAt(i).getName().equals(column_name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int fastFindColumnName(String col) {
        Object object = this.COL_LOOKUP_LOCK;
        synchronized (object) {
            Object ob;
            if (this.col_name_lookup == null) {
                this.col_name_lookup = new HashMap(30);
            }
            if ((ob = this.col_name_lookup.get(col)) == null) {
                int ci = this.findColumnName(col);
                this.col_name_lookup.put(col, new Integer(ci));
                return ci;
            }
            return (Integer)ob;
        }
    }

    public DataTableDef noColumnCopy() {
        DataTableDef def = new DataTableDef();
        def.setTableName(this.getTableName());
        def.table_type_class = this.table_type_class;
        return def;
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.getName());
        out.writeUTF(this.getSchema());
        out.writeUTF(this.table_type_class);
        out.writeInt(this.column_list.size());
        for (int i = 0; i < this.column_list.size(); ++i) {
            ((DataTableColumnDef)this.column_list.get(i)).write(out);
        }
    }

    static DataTableDef read(DataInput in) throws IOException {
        DataTableDef dtf = new DataTableDef();
        int ver = in.readInt();
        if (ver == 1) {
            throw new IOException("Version 1 DataTableDef no longer supported.");
        }
        if (ver == 2) {
            String rname = in.readUTF();
            String rschema = in.readUTF();
            dtf.setTableName(new TableName(rschema, rname));
            dtf.table_type_class = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                DataTableColumnDef col_def = DataTableColumnDef.read(in);
                dtf.column_list.add(col_def);
            }
        } else {
            throw new Error("Unrecognized DataTableDef version (" + ver + ")");
        }
        dtf.setImmutable();
        return dtf;
    }
}

